function lx=lagr(x,y);
%LAGR vraca Lagranzov polinom
%lx=lagr(x,y)
%lx - Lagranzov polinom kao vektor keoficijenata polinoma sa 0-tim clanom na poziciji 1
%x - vektor cvorova nad kojim se radi interpolacija
%y - vektor vrijednosti funkcije u cvorovima

global BrRacOp

n=size(x,2);
lx=zeros(1,n);
for i = 1:n
    t1=1;
    t2=1;
    for j=1:n
        if i~=j
            t1=mnozpol([-x(j),1],t1); 
            t2=t2*(x(i)-x(j));
            BrRacOp = BrRacOp + 2;
        end
    end
    BrRacOp = BrRacOp-3;
    lx=lx+(t1/t2)*y(i);
    BrRacOp = BrRacOp + 2*size(t1,2)+1;
end;
